#!/usr/bin/env python3
"""
SCARMONIT Key Spammer - Main Entry Point

A key/mouse spammer with human-like timing, window focus detection,
and profile management. Styled with the SCARMONIT dark theme.

Usage:
    python main.py

Hotkeys:
    F6 - Start spamming
    F7 - Stop spamming
"""

import sys
import os

# Ensure the package root is in the path
package_root = os.path.dirname(os.path.abspath(__file__))
if package_root not in sys.path:
    sys.path.insert(0, package_root)


def check_dependencies():
    """Check if required dependencies are installed"""
    missing = []

    try:
        import customtkinter
    except ImportError:
        missing.append("customtkinter")

    try:
        import pynput
    except ImportError:
        missing.append("pynput")

    # pydirectinput is optional (Windows only)
    if sys.platform == 'win32':
        try:
            import pydirectinput
        except ImportError:
            print("[WARNING] pydirectinput not installed. Using pynput fallback.")
            print("          For better performance on Windows, install: pip install pydirectinput")

        try:
            import win32gui
        except ImportError:
            print("[WARNING] pywin32 not installed. Window focus detection disabled.")
            print("          To enable, install: pip install pywin32")

    if missing:
        print("ERROR: Missing required dependencies:")
        for dep in missing:
            print(f"  - {dep}")
        print("\nInstall with: pip install -r requirements.txt")
        sys.exit(1)


def main():
    """Main entry point"""
    print("=" * 50)
    print("  SCARMONIT Key Spammer")
    print("  Press F6 to Start | F7 to Stop")
    print("=" * 50)
    print()

    # Check dependencies
    check_dependencies()

    # Import and run the app
    from gui.app import run_app
    run_app()


if __name__ == "__main__":
    main()
