"""
SCARMONIT Theme - Dark theme with orange/gold accents
Matches the SCARMONIT D4 Build Guides website styling
"""

# Color Palette
COLORS = {
    # Backgrounds
    "bg_dark": "#0d0d12",           # Main window background
    "bg_panel": "#151519",          # Panel/card background
    "bg_input": "#1a1a1f",          # Input field background
    "bg_hover": "#1f1f25",          # Hover state background

    # Accent Colors
    "accent_orange": "#d4a017",     # Primary orange/gold (buttons, highlights)
    "accent_orange_hover": "#e6b422", # Orange hover state
    "accent_red": "#dc3545",        # Delete button
    "accent_red_hover": "#e74c3c",  # Delete hover state
    "accent_green": "#28a745",      # Success/running state

    # Text Colors
    "text_primary": "#ffffff",      # Main text
    "text_secondary": "#e0e0e0",    # Slightly dimmed text
    "text_muted": "#9ca3af",        # Muted/placeholder text
    "text_disabled": "#6b7280",     # Disabled state text

    # Borders & Dividers
    "border": "#2a2a35",            # Subtle borders
    "border_focus": "#d4a017",      # Focused input border
    "section_bar": "#d4a017",       # Orange left bar on section headers

    # Status Colors
    "status_running": "#28a745",    # Green - running
    "status_stopped": "#dc3545",    # Red - stopped
    "status_paused": "#ffc107",     # Yellow - paused
}

# Font Configuration
FONTS = {
    "family": "Segoe UI",           # Clean sans-serif (Windows)
    "family_fallback": "Arial",     # Fallback font

    # Font sizes
    "size_title": 18,               # Window title
    "size_section": 14,             # Section headers
    "size_normal": 12,              # Normal text
    "size_small": 10,               # Small/muted text

    # Font weights
    "weight_bold": "bold",
    "weight_normal": "normal",
}

# Widget Styling
WIDGET_CONFIG = {
    # Corner radius
    "corner_radius_large": 8,
    "corner_radius_medium": 6,
    "corner_radius_small": 4,

    # Padding
    "padding_large": 20,
    "padding_medium": 15,
    "padding_small": 10,
    "padding_tiny": 5,

    # Border width
    "border_width": 1,
    "border_width_focus": 2,
}

# Button Styles
BUTTON_STYLES = {
    "primary": {
        "fg_color": COLORS["accent_orange"],
        "hover_color": COLORS["accent_orange_hover"],
        "text_color": COLORS["bg_dark"],
        "corner_radius": WIDGET_CONFIG["corner_radius_medium"],
    },
    "danger": {
        "fg_color": COLORS["accent_red"],
        "hover_color": COLORS["accent_red_hover"],
        "text_color": COLORS["text_primary"],
        "corner_radius": WIDGET_CONFIG["corner_radius_medium"],
    },
    "secondary": {
        "fg_color": COLORS["bg_panel"],
        "hover_color": COLORS["bg_hover"],
        "text_color": COLORS["text_primary"],
        "border_color": COLORS["border"],
        "corner_radius": WIDGET_CONFIG["corner_radius_medium"],
    },
}

# Input Field Styles
INPUT_STYLES = {
    "fg_color": COLORS["bg_input"],
    "border_color": COLORS["border"],
    "text_color": COLORS["text_primary"],
    "placeholder_text_color": COLORS["text_muted"],
    "corner_radius": WIDGET_CONFIG["corner_radius_small"],
    "border_width": WIDGET_CONFIG["border_width"],
}

# Checkbox Styles
CHECKBOX_STYLES = {
    "fg_color": COLORS["accent_orange"],
    "hover_color": COLORS["accent_orange_hover"],
    "border_color": COLORS["border"],
    "checkmark_color": COLORS["bg_dark"],
    "text_color": COLORS["text_primary"],
    "corner_radius": WIDGET_CONFIG["corner_radius_small"],
}

# Dropdown/Option Menu Styles
DROPDOWN_STYLES = {
    "fg_color": COLORS["bg_input"],
    "button_color": COLORS["accent_orange"],
    "button_hover_color": COLORS["accent_orange_hover"],
    "dropdown_fg_color": COLORS["bg_panel"],
    "dropdown_hover_color": COLORS["bg_hover"],
    "text_color": COLORS["text_primary"],
    "corner_radius": WIDGET_CONFIG["corner_radius_small"],
}


def get_section_header_style():
    """Returns style dict for section headers with orange left bar"""
    return {
        "text_color": COLORS["text_primary"],
        "font": (FONTS["family"], FONTS["size_section"], FONTS["weight_bold"]),
    }


def get_label_style(muted=False):
    """Returns style dict for labels"""
    return {
        "text_color": COLORS["text_muted"] if muted else COLORS["text_primary"],
        "font": (FONTS["family"], FONTS["size_normal"], FONTS["weight_normal"]),
    }
